/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xreliquary.Reliquary;
import xreliquary.handler.CommonEventHandler;
import xreliquary.handler.HandlerPriority;
import xreliquary.handler.IPlayerDeathHandler;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.reference.Settings;
import xreliquary.util.EntityHelper;
import xreliquary.util.InventoryHelper;

public class ItemAngelheartVial
extends ItemBase {
    public ItemAngelheartVial() {
        super("angelheart_vial");
        this.func_77637_a(Reliquary.CREATIVE_TAB);
        this.func_77656_e(0);
        this.func_77625_d(64);
        this.canRepair = false;
        CommonEventHandler.registerPlayerDeathHandler(new IPlayerDeathHandler(){

            @Override
            public boolean canApply(EntityPlayer player, LivingDeathEvent event) {
                return InventoryHelper.playerHasItem(player, ModItems.angelheartVial);
            }

            @Override
            public boolean apply(EntityPlayer player, LivingDeathEvent event) {
                ItemAngelheartVial.decreaseAngelHeartByOne(player);
                ItemAngelheartVial.spawnAngelheartVialParticles(player);
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187561_bM, SoundCategory.NEUTRAL, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                float amountHealed = player.func_110138_aP() * (float)Settings.Items.AngelHeartVial.healPercentageOfMaxLife / 100.0f;
                player.func_70606_j(amountHealed);
                if (Settings.Items.AngelHeartVial.removeNegativeStatus) {
                    EntityHelper.removeNegativeStatusEffects((EntityLivingBase)player);
                }
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.LOW;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        return new ItemStack((Item)ModItems.potion, 1, 0);
    }

    public boolean hasContainerItem(ItemStack ist) {
        return true;
    }

    private static void spawnAngelheartVialParticles(EntityPlayer player) {
        double var8 = player.field_70165_t;
        double var10 = player.field_70163_u;
        double var12 = player.field_70161_v;
        Random var7 = player.field_70170_p.field_73012_v;
        for (int var15 = 0; var15 < 8; ++var15) {
            player.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, var8, var10, var12, var7.nextGaussian() * 0.15, var7.nextDouble() * 0.2, var7.nextGaussian() * 0.15, new int[]{Item.func_150891_b((Item)Items.field_151068_bn)});
        }
        float red = 1.0f;
        float green = 0.0f;
        float blue = 1.0f;
        for (int var20 = 0; var20 < 100; ++var20) {
            Particle var31;
            double var39 = var7.nextDouble() * 4.0;
            double var23 = var7.nextDouble() * Math.PI * 2.0;
            double var25 = Math.cos(var23) * var39;
            double var27 = 0.01 + var7.nextDouble() * 0.5;
            double var29 = Math.sin(var23) * var39;
            if (!player.field_70170_p.field_72995_K || (var31 = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.SPELL.func_179348_c(), var8 + var25 * 0.1, var10 + 0.3, var12 + var29 * 0.1, var25, var27, var29, new int[0])) == null) continue;
            float var32 = 0.75f + var7.nextFloat() * 0.25f;
            var31.func_70538_b(red * var32, green * var32, blue * var32);
            var31.func_70543_e((float)var39);
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187561_bM, SoundCategory.NEUTRAL, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    private static void decreaseAngelHeartByOne(EntityPlayer player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190926_b() || ((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_77973_b() != ModItems.angelheartVial) continue;
            player.field_71071_by.func_70298_a(slot, 1);
            return;
        }
    }
}

